package gov.va.med.mhv.integration.phr.service.cvix;

import gov.va.med.mhv.integration.phr.service.AbstractBaseQueryService;
import gov.va.med.mhv.integration.phr.service.cvix.client.CVIXClient;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * User: Rob Murtha
 */
public abstract class BaseCvixQueryService extends AbstractBaseQueryService {
	
	protected CVIXClient cvixService = null;
	
	public void setCvixService(CVIXClient cvixService) {
		this.cvixService = cvixService;
	}
	
	
	public CVIXClient getCvixService() {
		List<String> audit = new ArrayList<String>();
		
		if (cvixService.getAudit().size() == 0)
			audit.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(new Date()) + " - Start");
		
		cvixService.setAudit(audit);
		return cvixService;
	}
	
}
